unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  UKlasy;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    btnCLOSE: TBitBtn;
    btnSPR: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure btnSPRClick(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormPaint(Sender: TObject);
  private

  public
	pro : Figura;		// uchwyt na prostokt
	kol : Figura;		// uchwyt na koo
	tro : Figura;		// uchwyt na trjkt

    procedure Spr();
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm1.btnCLOSEClick(Sender: TObject);
begin
   Close();
end;

procedure TForm1.btnSPRClick(Sender: TObject);
begin
   Spr();
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
   ShowMessage('Aby uzyska trway rusunek odblokuj kod w OnPaint');
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if Assigned(pro) then
   begin
		FreeAndNil(pro);
   end;

   if Assigned(kol) then
   begin
		FreeAndNil(kol);
   end;

   if Assigned(tro) then
   begin
		FreeAndNil(tro);
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
	pro := Nil;
   kol := Nil;
   tro := Nil;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   if Assigned(pro) then
   begin
      FreeAndNIl(pro);
   end;

   if Assigned(kol) then
   begin
      FreeAndNIl(kol);
   end;


   if Assigned(tro) then
   begin
      FreeAndNIl(tro);
   end;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
	// Aby uzyska "trway" rysunek odblokuj ponisz lini
	// spr();
end;

procedure TForm1.Spr();
var
   x1 : Integer;
   y1 : Integer;
   x2 : Integer;
   y2 : Integer;

begin
   Canvas.Pen.Color   := clBlue;
   Canvas.Brush.Style := bsSolid;
   Canvas.Brush.Color := clBlue;

   x1 := 100;
   y1 := 100;
   x2 := 150;
   y2 := 150;
   // pro := Prostokat.Create(Form1.Canvas, R);
	pro := Prostokat.Create(Form1.Canvas, x1, y1, x2, y2);
   pro.Show();

   Canvas.Pen.Color   := clRed;
   Canvas.Brush.Style := bsSolid;
   Canvas.Brush.Color := clRed;
   x1 := 200;
   y1 := 200;
   x2 := 250;
   y2 := 250;
   kol := Kolo.Create(Form1.Canvas, x1, y1, x2, y2);
   kol.Show();

   Canvas.Pen.Color   := clGreen;
   Canvas.Brush.Style := bsSolid;
   Canvas.Brush.Color := clGreen;
	// trojkat bedzie rysowany jako wpisany w prostokat
   // wierzcholiem do gory
	// R := Rect(300, 300, 350, 350);
   x1 := 300;
   y1 := 300;
   x2 := 350;
   y2 := 350;
   tro := Trojkat.Create(Form1.Canvas, x1, y1, x2, y2);
   tro.Show();
end;

end.

